#include <bits/stdc++.h>
#define endl '\n'
#define MAXN 500000
#define ll long long

ll popul[MAXN], nearest[MAXN];

using namespace std;

ll n, k;

ll next(ll i){
    i++;
    return (i >= n ? 0 : i);
}

ll calcDistance(ll i1, ll i2){
    int d1 = abs(i1 - i2);
    int d2 = min(i1, i2) + (n - max(i1, i2));
    return min(d1, d2);
}

ll prev(ll i){
    i--;
    return (i < 0 ? n - 1 : i);
}

void recalc(ll i){
    ll n = i, p = i;
    ll dist = 0;
    nearest[i] = 0;

    while(true){ //napred
        n = next(n);
        dist = calcDistance(n, i);

        if(dist >= nearest[n]) break;
        nearest[n] = dist;
    }

    dist = 0;
    while(true){ //nazad
        p = prev(p);
        dist = calcDistance(p, i);

        if(dist >= nearest[p]) break;
        nearest[p] = dist;
    }
}

ll findNum(ll i){
    if(nearest[i] == 0) return 0;

    ll o = popul[i];

    ll n = i, p = i;
    ll dist = 0;
    while(true){ //napred
        n = next(n);
        dist = calcDistance(n, i);

        if(dist > nearest[n]) break;

        if(dist == nearest[n]){
            o += popul[n] / 2;
            break;
        }

        o += popul[n];
    }

    dist = 0;
    while(true){ //nazad
        p = prev(p);
        dist = calcDistance(p, i);

        if(dist > nearest[p]) break;

        if(dist == nearest[p]){
            o += popul[p] / 2;
            break;
        }

        o += popul[p];
    }

    return o;
}

pair<ll, ll> place(){
    ll maxN = 0, maxI = 0;
    for(ll i = 0; i < n; i++){
        ll t = findNum(i);
        if(t > maxN) {
            maxN = t;
            maxI = i;
        }
    }

    return pair<ll, ll>(maxN, maxI);
}

int main(){
    ios::sync_with_stdio(false); cin.tie(0);
    cin>>n>>k;

    ll shops[k];
    //ll popul[n];
    //ll nearest[n];

    for(ll i = 0; i < k; i++){
        cin>>shops[i];
    }

    sort(shops, shops + k);

    ll totalPopul = 0;
    ll maxPossible = 0;
    for(ll i = 0; i < n; i++){
        cin>>popul[i];
        totalPopul += popul[i];

        ll num = i + 1; //broj grada
        ll index = lower_bound(shops, shops + k, num) - shops;

        ll index1 = index;
        ll index2 = index - 1;
        if(index1 >= k) index1 = 0;
        if(index2 < 0) index2 = k - 1;
        nearest[i] = min(calcDistance(num - 1, shops[index1] - 1), calcDistance(num - 1, shops[index2] - 1));

        /*if(index == k){
            nearest[i] = num - shops[k - 1];
        }else if(index < 1){
            nearest[i] = abs(num - shops[index]);
        }else{
            nearest[i] = min(abs(num - shops[index]), abs(num - shops[index - 1]));
        }

        ll nearestBack = abs(num + n - shops[k - 1]);
        if(nearestBack < nearest[i]) nearest[i] = nearestBack;

        ll nearestFront = abs(num - n - shops[0]);
        if(nearestFront < nearest[i]) nearest[i] = nearestFront;*/

        if(nearest[i] > 0) {
            maxPossible += popul[i];
        }
    }

    ll reqPopul = totalPopul / 2;
    if(maxPossible < reqPopul) {
        cout<<"-1";
        return 0;
    }

    ll current = 0, newShops = 0;;
    while(current <= reqPopul){
        pair<ll, ll> l = place();
        current += l.first;
        newShops++;

        if(current > reqPopul){
            cout<<newShops;
            return 0;
        }

        recalc(l.second);
    }

    return 0;
}